-- events for credits


-- Strings that need localization
--
T_DEVELOPED_BY = Localize ("Developed By");
T_RA_PRODUCERS = Localize ("RealArcade Producers");
T_MUSIC_BY = Localize ("Music By");
T_ARTIST = Localize ("Background Artist");
T_GAME_TESTERS = Localize ("Game Testers");


lines = {};

i = 0;
lines[i] = "";										i = i + 1;
lines[i] = T_DEVELOPED_BY;				i = i + 1;
lines[i] = "Tero Alatalo";				i = i + 1;
lines[i] = "Sampo Tyssy";				i = i + 1;
lines[i] = "";										i = i + 1;
lines[i] = T_RA_PRODUCERS;				i = i + 1;
lines[i] = "Sarah Brass";					i = i + 1;
lines[i] = "Mark Magdamit";				i = i + 1;
lines[i] = "";										i = i + 1;
lines[i] = T_MUSIC_BY;						i = i + 1;
lines[i] = "Adamantium Studios";	i = i + 1;
lines[i] = "";										i = i + 1;
lines[i] = T_ARTIST;							i = i + 1;
lines[i] = "Jussi Lehtiniemi / LBI Digital";	i = i + 1;
lines[i] = "";				i = i + 1;
lines[i] = T_GAME_TESTERS;		i = i + 1;
lines[i] = "Maria Alatalo";		i = i + 1;
lines[i] = "Mika Alatalo";		i = i + 1;
lines[i] = "Toni Brman";		i = i + 1;
lines[i] = "Tom Eklund";	i = i + 1;
lines[i] = "Jarkko Forsbacka";	i = i + 1;
lines[i] = "Eveliina Houni";	i = i + 1;
lines[i] = "Marko Kanerva";	i = i + 1;
lines[i] = "Elli Kotakorpi";	i = i + 1;
lines[i] = "Miikka Kulmala";	i = i + 1;
lines[i] = "Kuisma Kuusniemi";	i = i + 1;
lines[i] = "Teemu Lempiinen";	i = i + 1;
lines[i] = "Juha Pakkanen";	i = i + 1;
lines[i] = "Timo Pohja";		i = i + 1;
lines[i] = "Saara Tyssy";	i = i + 1;
lines[i] = "Piia Vepslinen";	i = i + 1;
lines[i] = "Sari Yltv";	i = i + 1;
lines[i] = "";				i = i + 1;
lines[i] = "2007 (c) MythPeople";	i = i + 1;
num_lines = i;
scroller_y = 0;



function OnLoad ()
	SetProperty ("/Credits:enable_event_on_key_down", 1);
	NX_GetBitmap("ui/gfx/adamantium-logo.png");	
end;


function OnEnter ()
	scroller_y = 0;

end;

function OnLeave ()
end;


function OnClick (name)
	if (name == "Ok") then
		PopScreen ();
		return;
	end;
end;

function OnKeyDown (key)
	if (scroller_y < 30) then
		return;
	end;
	
	Print("Any Key Down (" .. key .. ")\n");
	if (key == "ESCAPE" or
	    key == "MOUSE_BUTTON_0" or
	    key == "MOUSE_BUTTON_1") then
		PopScreen ();
	end;
end;


function OnUpdate (tdelta)

	--akey = GetActiveScreenAnimKey ();
	trans = GetActiveScreenTransPhase ();
	SetProperty ("fader:alpha", trans);
	
	scroller_y = scroller_y + 40 * tdelta;
end;


function OnDraw ()

	
	pos_x = GetVar ("ScreenWidth") / 2;
	pos_y = GetVar ("ScreenHeight") + 60;
	NX_SetAlpha (1);
	NX_SetColor (1,1,1);
	NX_SetTextAlign ("CENTER");
	
	trans = GetActiveScreenTransPhase ();
	NX_SetAlpha (trans);
		
	font = "fonts/small.mft";
	
	--NX_DrawText (font, 100, 10, "Scroll y = " .. scroller_y);
	
	NX_DrawBitmapRS ("ui/gfx/azkend-logo.png", pos_x, pos_y - scroller_y, 0, 1);
	
	pos_y = pos_y + 100;
	
	i = 1; -- skip the first line that's empty (emptiness is used to detech headlines :)
	while (i < num_lines) do
		line_height = 20;
		
		if (lines[i-1] == "") then
			font = "fonts/big.mft";
			line_height = 44;
		else
			font = "fonts/small.mft";
			line_height = 30;
		end;
		
		if (lines[i] == "") then
			line_height = 50;
		end;
				
		
		NX_DrawText (font, pos_x, pos_y - scroller_y, lines[i]);
		
		if (i == 9) then
		    line_height = 0
		    pos_y = pos_y + 75
		    NX_DrawBitmapRS ("ui/gfx/adamantium-logo.png", pos_x, pos_y - scroller_y, 0, 1);	
		    pos_y = pos_y + 50	    
		end;
		
		i = i + 1;
		pos_y = pos_y + line_height;
	end;
	
	NX_DrawBitmapRS ("mythpeople/mythpeople-logo.png", pos_x, pos_y - scroller_y + 50, 0, 1);
	
	
	-- let it wrap around
	if (pos_y - scroller_y < -100) then
		scroller_y = 0;
	end;
	


	NX_SetTextAlign ("TOPLEFT");
	NX_SetAlpha (1);
	NX_SetColor (1,1,1);

end;
